using System;
using System.Runtime.InteropServices;
using System.Text;

namespace Sony
{
	namespace NP
	{
        public class Main
		{
			// Sony Np Toolkit creation flags...
			// kNpToolkit_CreateCacheTrophyIcons - trophy icons will be cached, uses more memory so only use this if you intend to display trophy icons in your game.
			public static int kNpToolkitCreate_CacheTrophyIcons = 1 << 0;
			public static int kNpToolkitCreate_NoRanking = 1 << 1;

			// Initialization.
			[DllImport("UnityNpToolkit")]
			private static extern int PrxInitialize(int creationFlags);
			[DllImport("UnityNpToolkit")]
			private static extern int PrxInitializeWithNpAgeRating(int creationFlags, int npAgeRating);

			[DllImport("UnityNpToolkit")]
			private static extern bool PrxGetLoggingEnabled();
			[DllImport("UnityNpToolkit")]
			private static extern void PrxSetLoggingEnabled(bool enabled);

			[DllImport("UnityNpToolkit", CharSet = CharSet.Ansi)]
			private static extern void PrxSetSessionImage(string imageFilePath);

			// Termination
			[DllImport("UnityNpToolkit")]
			private static extern void PrxShutDown();

			// House keeping.
			[DllImport("UnityNpToolkit")]
			private static extern int PrxUpdate();

			public static event NP.Messages.EventHandler OnLog;
			public static event NP.Messages.EventHandler OnLogWarning;
			public static event NP.Messages.EventHandler OnLogError;
			public static event NP.Messages.EventHandler OnNPInitialized;

			public static bool enableInternalLogging
			{
				get
				{
					return PrxGetLoggingEnabled();
				}
				set
				{
					PrxSetLoggingEnabled(value);
				}
			}

			public static void Initialize(int creationFlags)
			{
				PrxInitialize(creationFlags);
			}

			// Set the session image file path, required for messaging on PS4.
			public static void SetSessionImage(string imageFilePath)
			{
				PrxSetSessionImage(imageFilePath);
			}

			// Initialise Np Toolkit and specify an age rating, if npAgeRating < 0 then the value set in the editors player settings is used.
			public static void InitializeWithNpAgeRating(int creationFlags, int npAgeRating)
			{
				PrxInitializeWithNpAgeRating(creationFlags, npAgeRating);
			}

			public static void Update()
			{
				PrxUpdate();
				PumpMessages();
			}

			public static void ShutDown()
			{
				PrxShutDown();
			}

			static void PumpMessages()
			{
				while (NP.Messages.HasMessage())
				{
					NP.Messages.PluginMessage msg = new NP.Messages.PluginMessage();
					NP.Messages.GetFirstMessage(out msg);

					// Interpret the message and trigger corresponding events.

					NP.System.ProcessMessage(msg);
					NP.User.ProcessMessage(msg);
					NP.Friends.ProcessMessage(msg);
					NP.Trophies.ProcessMessage(msg);
					NP.Ranking.ProcessMessage(msg);
					NP.Matching.ProcessMessage(msg);
					NP.Messaging.ProcessMessage(msg);
					NP.WordFilter.ProcessMessage(msg);
					NP.Commerce.ProcessMessage(msg);
					NP.Ticketing.ProcessMessage(msg);
					NP.TusTss.ProcessMessage(msg);
					NP.Dialogs.ProcessMessage(msg);
					NP.Facebook.ProcessMessage(msg);
					NP.Twitter.ProcessMessage(msg);
					NP.Requests.ProcessMessage(msg);

					switch (msg.type)
					{
						case NP.Messages.MessageType.kNPToolKit_Log:
							if (OnLog != null) OnLog(msg);
							break;

						case NP.Messages.MessageType.kNPToolKit_LogWarning:
							if (OnLogWarning != null) OnLogWarning(msg);
							break;

						case NP.Messages.MessageType.kNPToolKit_LogError:
							if (OnLogError != null) OnLogError(msg);
							break;

						case NP.Messages.MessageType.kNPToolKit_NPInitialized:
							if (OnNPInitialized != null) OnNPInitialized(msg);
							break;

					}

					NP.Messages.RemoveFirstMessage();
				}
			}
		}
	} // NP
} // Sony
